﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using Winfoot_7_SDK;
using WinfootDefaultSystemPlugin.Controls.Strategy;

namespace WinfootDefaultSystemPlugin.Controls
{
    public partial class IsShortcut : UserControl, IControl, ICorrespondenceOS
    {
        private IsShortcutController isShortcutController;

        public IsShortcut()
        {
            InitializeComponent();
            CorrespondenceOSList = new List<OS>
                                       {
                                           OS.WindowsXP,
                                           OS.WindoesXP_SP1,
                                           OS.WindowsXP_SP2,
                                           OS.WindowsXP_SP3,
#if DEBUG
                                           OS.WindowsVista,
                                           OS.WindowsVista_SP1,
                                           OS.WindowsSeven
#endif
                                       };
        }

        private void groupBox1_MouseClick(object sender, MouseEventArgs e)
        {
            if (e.Button == MouseButtons.Right)
            {
                UserHelp userHelp = new UserHelp(new Uri(@"http://www.google.co.jp/"));
                userHelp.Show();
            }
        }

        public void SetIsShortcutState(bool b)
        {
            checkBox1.Checked = b;
        }


        public bool GetIsShortcutState()
        {
            return checkBox1.Checked;
        }

        #region IControl メンバ

        public void Apply()
        {
            isShortcutController.Write();
        }

        public List<WFRegistry> BackUp()
        {
            return isShortcutController.BackUp();
        }

        #endregion

        #region ICorrespondenceOS メンバ

        public List<OS> CorrespondenceOSList { get; set; }

        #endregion

        private void IsShortcut_Load(object sender, EventArgs e)
        {
            WFUtillity wfUtillity = new WFUtillity();
            isShortcutController = new IsShortcutController(this,
                                                                        (IIsShortcutStrategy)
                                                                        wfUtillity.
                                                                            GetCorrespondenceInstance
                                                                            (new List<ICorrespondenceOS>
                                                                                 {
                                                                                     new IsShortcutDefaultStrategy()
                                                                                 }));
            isShortcutController.Read();
        }
    }
}